## Build

```
<ENV=VAL...> ./build.sh
```

The following environment variables are optional, but can be prepended to the command as documented above.
1. BUILD_DIR: output directory for artifacts (default: ./build)
2. STAGING_DIR: directory for intermediate build and packaging (default: ./dist)
3. DTR_PREFIX: prefix for target Docker trusted registry (only read is currently needed, default: dev)
4. DTR_ORG: organization label for target Docker trusted registry (only read is currently needed, default: blank)
5. BUILD_NUMBER: build number
6. APPDATE: build date

Note for developers: leaving both DTR_PREFIX and DTR_ORG blank will default the build to use the source docker image at dev/image (unless overridden in app.env, for example).  This can be done when building out the images manually and automatically tagging to the local dev registry.  For more detailed information on this process, see the following development setup instructions at <wiki url>

## Build the project for local deployment

1. Build the *centos7-base* docker image (see project for instructions)
2. Build the *centos7-openjdk8* docker image (see project for instructions)
3. Build the *centos7-openjdk8-tomcat* docker image (see project for instructions)
4. From the var-resources project directory, run `source app.env`
5. From the var-resources project directory, Run `build.sh`
6. Change directory to *dist*
7. From *dist* folder, Run `docker build -t dev/var-resources .`

Note: Steps 1-3 are only require to be executed once. Only the project build is necessary when changes are made to the project.

## Running Locally Without Innovations Stack

1. Run `docker run -p 9092:8080 dev/var-resources`

## Running Locally With the Innovations Stack

1.  Add the following section of code to the docker-compose.yml file in the docker local development project. 
(https://URL                  .DOMAIN.EX/projects/DEV/repos/docker-local-development/)

*Warning* Spacing in yaml is important
```
var-resources:
  image: dev/var-resources
  links:
   - var-messaging-microservice
  depends_on:
   - var-messaging-microservice
  ports:
   - "9092:8080"
   - "64058:64058"
  environment:
   - SERVICE_64058_IGNORE=true
   - SERVICE_TAGS=local
   - SERVICE_NAME=var-resources
   - JWT_SECRET=testtesttest
   - JAVA_OPTS=-XX:+CMSClassUnloadingEnabled -Xrs -Djavax.xml.soap.MessageFactory=weblogic.xml.saaj.MessageFactoryImpl -Dcom.sun.xml.ws.transport.http.client.HttpTransportPipe.dump=true -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=64058
```
Note the dependency on the VMM, ensure you have the VMM in your local stack as well.  The 64058 port is used for remote debugging -- this will not be exposed in a prod setting.

2. Add the curl command to the run.sh file in the dockerlocal_development stack

    ```
    curl -H "X-Consul-Token: 7BE784A4-7498-4469-BE2F-9C3B9444DFEF" -s -X PUT localhost:8500/v1/kv/vamf/local/apigateway/1.0/services/var-resources -d '{"location":"/VeteranAppointmentRequestService","service":"var-resources-8080","redirect":"off","headers":{"X-Real-IP":"$remote_addr"}}' > /dev/null
    ```

3. To view changes while working in the innovation stack:
    1. Run these two commands in the terminal at the root of this repo
        1. Run `build.sh`
        2. From *dist* folder, run `docker build -t dev/var-resources .`
    2. Run these two commands in the terminal at the docker-local-development directory
        1. `docker-compose kill var-resources`
        2. `docker-compose up -d var-resources`
        
## Configuring VAR Resources

If the default values in the properties files located in `src/main/resources/properties` are not sufficient, you can override any of them by adding an environment variable under the `environment:` section of the `docker-compose.yml` file, such as the example below that changes the number of days for recall.

```
var-resources:
  image: dev/var-resources
  links:
   - var-messaging-microservice
  depends_on:
   - var-messaging-microservice
  ports:
   - "9092:8080"
  environment:
   - SERVICE_TAGS=local
   - SERVICE_NAME=var-resources
   - JWT_SECRET=testtesttest
   - JAVA_OPTS=-XX:+CMSClassUnloadingEnabled -Xrs -Djavax.xml.soap.MessageFactory=weblogic.xml.saaj.MessageFactoryImpl -Dcom.sun.xml.ws.transport.http.client.HttpTransportPipe.dump=true
   - recall.num.days=45
```

## Running unit tests
Simply run `gradlew test`. Tests can be run and debugged from IntelliJ: right click the 'test' folder (or any package or spec below) and select 'Run' or 'Debug'. T